# 创建索引

Joe 想给 Goods 表

```sql
create table goods(
    id int primary key auto_increment,
    category_id int,
    name varchar(256),
    price decimal(12, 4),
    stock int,
    upper_time timestamp
)
```

的 category_id （类别）字段创建索引，便于根据类别查询商品。应该执行下面哪个语句？

*注意* 一个类别会包含多种商品。

<hr/>

点击进入[MySQL实战练习环境](https://mydev.csdn.net/product/pod/new?image=cimg-centos7-skilltreemysql&connect=auto&create=auto&utm_source=skill){target="_blank"}。

* `show databases;` 列出所有数据库
* `show tables;` 列出所有表

## 答案

```sql
create index idx_goods_category on goods(category_id);
```

## 选项

### A

```sql
create unique index idx_goods_category on goods(category_id);
```

### B

```sql
create index idx_goods_category on goods(name);
```

### C

```sql
alter table goods add unique index (category_id);
```